/*****************************************************************************
 *   dma.c:  DMA module file for NXP LPC23xx/24xx Family Microprocessors
 *
 *   Copyright(C) 2006, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2006.07.20  ver 1.00    Preliminary version, first Release
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *****************************************************************************/

#include "LPC29xx.h"                        /* LPC23xx/24xx definitions */
#include "type.h"
#include "irq.h"
#include "FOC.h"
#include "dma.h"

/******************************************************************************
** Function name:		DMAHandler
**
** Descriptions:		DMA interrupt handler
**
** parameters:			None
** Returned value:		None
** 
******************************************************************************/
void DMAHandler (void) 
{
    DWORD regVal;
    
    regVal = GPDMA_INT_TCSTAT;
    if(regVal)GPDMA_INT_TCCLR |= regVal;
    
    regVal = GPDMA_INT_ERR_STAT;
    if(regVal)GPDMA_INT_ERR_CLR |= regVal;
}

/******************************************************************************
** Function name:		DMA_Init
**
** Descriptions:		
**
** parameters:			
** Returned value:		
** 
******************************************************************************/
DWORD DMA_Init(  FOC_STRUCT *datastr  )
{
    static LinkedList LL_FOR_UART_TX;

    LL_FOR_UART_TX.SRC  = (unsigned long )datastr;
    LL_FOR_UART_TX.DST  = 0xE0045000; // U0THR
    LL_FOR_UART_TX.LLI  = (unsigned long)&LL_FOR_UART_TX; 
    LL_FOR_UART_TX.CTRL = ((sizeof(*datastr))  << 0) | (0x00 << 12) | (0x3 << 15) |
    	                  (0x00 << 18) | (0x00 << 21) | (1 << 26) | 
                          (0 << 27);

    GPDMA_INT_TCCLR = 0x01;
    GPDMA_INT_ERR_CLR = 0x01;
  
    GPDMA_CONFIG = (0x01 << 0);	// Enable DMA channels, little endian 

    GPDMA_CH0_LLI = (((unsigned long)&LL_FOR_UART_TX)&0xFFFFFFFC) | 0;

    GPDMA_CH0_SRC = LL_FOR_UART_TX.SRC;
    GPDMA_CH0_DEST = LL_FOR_UART_TX.DST;

    GPDMA_CH0_CTRL = LL_FOR_UART_TX.CTRL;
    GPDMA_CH0_CFG = (1 << 11) | (6 << 6) | (0x01 << 0);    
    
//    install_irq( GPDMA_INT, (void *)DMAHandler, HIGHEST_PRIORITY );
//    EnableIntReq_IRQ( GPDMA_INT, ACTIVE_HIGH, HIGHEST_PRIORITY );
	return (TRUE);
}
/******************************************************************************
**                            End Of File
******************************************************************************/
